/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.PropertyBook;
import ibm.nways.lspeed.LsBridgeConfig;
import java.awt.Choice;
import java.util.ResourceBundle;
import java.util.Vector;

public class AddrTableOutToWidget
extends Choice
implements JDMInput {
    private static String OutToFloodEncoding = "FF";
    private static String OutToFilterEncoding = "00";
    private static String OutToPortEncodeOneSlot = "000";
    private static String bundleName = "ibm.nways.lspeed.LsGeneralResources";
    private static ResourceBundle lspeedBundle = null;
    private Vector choiceList;
    private LsBridgeConfig.LsBridgeObject bridgeObj;

    private static int FloodChoice() {
        return 1;
    }

    private static int FilterChoice() {
        return 2;
    }

    private static int PortChoice() {
        return 3;
    }

    private static ResourceBundle getLspeedBundle() {
        if (lspeedBundle == null) {
            lspeedBundle = ResourceBundle.getBundle(bundleName);
        }
        return lspeedBundle;
    }

    public AddrTableOutToWidget() {
        this.setBackground(PropertyBook.selListBackColor);
        this.setForeground(PropertyBook.selListForeColor);
        this.choiceList = new Vector();
    }

    public void setVBridge(LsBridgeConfig.LsBridgeObject lsBridgeObject) {
        this.bridgeObj = lsBridgeObject;
        super.removeAll();
        this.choiceList.removeAllElements();
        ChoiceObject choiceObject = new ChoiceObject(AddrTableOutToWidget.FloodChoice(), null);
        this.choiceList.addElement(choiceObject);
        choiceObject = new ChoiceObject(AddrTableOutToWidget.FilterChoice(), null);
        this.choiceList.addElement(choiceObject);
        if (lsBridgeObject != null) {
            Vector vector = lsBridgeObject.getBridgePorts();
            int n = 0;
            while (n < vector.size()) {
                LsBridgeConfig.LsBridgePortObject lsBridgePortObject = (LsBridgeConfig.LsBridgePortObject)vector.elementAt(n);
                choiceObject = new ChoiceObject(AddrTableOutToWidget.PortChoice(), lsBridgePortObject);
                this.choiceList.addElement(choiceObject);
                ++n;
            }
        }
        int n = 0;
        while (n < this.choiceList.size()) {
            choiceObject = (ChoiceObject)this.choiceList.elementAt(n);
            this.addItem(choiceObject.getDescription());
            ++n;
        }
        this.invalidate();
    }

    public Object getValue() {
        OctetString octetString = null;
        String string = null;
        if (this.choiceList == null) {
            return null;
        }
        ChoiceObject choiceObject = (ChoiceObject)this.choiceList.elementAt(this.getSelectedIndex());
        if (choiceObject == null) {
            return null;
        }
        if (choiceObject.getType() == AddrTableOutToWidget.FloodChoice()) {
            string = OutToFloodEncoding;
        } else if (choiceObject.getType() == AddrTableOutToWidget.FilterChoice()) {
            string = OutToFilterEncoding;
        } else if (choiceObject.getType() == AddrTableOutToWidget.PortChoice()) {
            LsBridgeConfig.LsBridgePortObject lsBridgePortObject = choiceObject.getPortObj();
            string = this.encodeOutToPort(lsBridgePortObject.getSlot(), lsBridgePortObject.getPort());
        } else {
            System.out.println("Error encoding OutTo value");
        }
        try {
            octetString = new OctetString(string);
        }
        catch (Exception exception) {
            System.out.println("Error encoding OutTo value");
            exception.printStackTrace();
        }
        return octetString;
    }

    public String toString() {
        return this.getValue().toString();
    }

    public void setValue(Object object) {
        if (object instanceof LsBridgeConfig.LsBridgeObject) {
            this.setVBridge((LsBridgeConfig.LsBridgeObject)object);
        }
    }

    public void setValue(String string) {
    }

    public boolean isValidValue() {
        return true;
    }

    public boolean ignoreValue() {
        return false;
    }

    private String encodeOutToPort(int n, int n2) {
        String string = new String();
        int n3 = 1;
        while (n3 < n) {
            string = String.valueOf(string) + OutToPortEncodeOneSlot;
            ++n3;
        }
        int n4 = n2 / 4;
        int n5 = n2 % 4;
        if (n5 == 0) {
            --n4;
        }
        int n6 = 0;
        while (n6 < n4) {
            string = String.valueOf(string) + "0";
            ++n6;
        }
        switch (n5) {
            case 1: {
                string = String.valueOf(string) + "8";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "4";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "2";
                break;
            }
            default: {
                string = String.valueOf(string) + "1";
            }
        }
        if (string.length() % 2 != 0) {
            string = String.valueOf(string) + "0";
        }
        return string;
    }

    private class ChoiceObject {
        int choiceType;
        String description;
        LsBridgeConfig.LsBridgePortObject portObj;

        ChoiceObject(int n, LsBridgeConfig.LsBridgePortObject lsBridgePortObject) {
            AddrTableOutToWidget.this = AddrTableOutToWidget.this;
            this.choiceType = n;
            this.portObj = lsBridgePortObject;
            if (n == AddrTableOutToWidget.FloodChoice()) {
                this.description = AddrTableOutToWidget.getLspeedBundle().getString("AddrTableOutToFlood");
                return;
            }
            if (n == AddrTableOutToWidget.FilterChoice()) {
                this.description = AddrTableOutToWidget.getLspeedBundle().getString("AddrTableOutToFilter");
                return;
            }
            if (n == AddrTableOutToWidget.PortChoice()) {
                this.description = lsBridgePortObject.getKey();
                return;
            }
            this.description = null;
        }

        String getDescription() {
            return this.description;
        }

        int getType() {
            return this.choiceType;
        }

        LsBridgeConfig.LsBridgePortObject getPortObj() {
            return this.portObj;
        }
    }
}

